<?php
	header('X-Frame-Options: DENY');
	header('X-XSS-Protection: 1; mode=block');
	header('Content-Type: text/html; charset=utf-8');

	include('../../../inc/db.php');
	include('../../../inc/classes/class.template.php');

	$tpl = new Template;
	$tpl->dir = '../tpl/ajax/';

	$limit = isset($_POST['limit']) ? $_POST['limit'] : 'full';

	$qlimit = is_numeric($limit) ? 'LIMIT '.intval($limit) : '';

	$servers = $pdo->query('SELECT `sid`, `name`, `map`, `players_max`, `players_now` FROM `monitoring` ORDER BY `id` '.$qlimit);
			 $servers->setFetchMode(PDO::FETCH_OBJ);

	$tpl->result['content'] = '';

	while($server = $servers->fetch())
	{
		$query = $pdo->query('SELECT `address` FROM `servers` WHERE `id`="'.$server->sid.'" LIMIT 1');
				 $query->setFetchMode(PDO::FETCH_OBJ);
		$info = $query->fetch();

		$tpl->load_template('servers.tpl');
			$tpl->set('{name}', $server->name);
			$tpl->set('{map_img}', ($server->map && file_exists('../../../files/maps_imgs/'.$server->map.'.jpg')) ? '/files/maps_imgs/'.$server->map.'.jpg' : '/files/maps_imgs/none.jpg');
			$tpl->set('{map_name}', $server->map);
			$tpl->set('{max}', $server->players_max);
			$tpl->set('{now}', $server->players_now);
			$tpl->set('{address}', $info->address);
			$tpl->set('{id}', $server->sid);
		$tpl->compile('content');
	}

	$query = $pdo->query('SELECT `id` FROM `monitoring`');

	if($limit != 'full' && $limit < count($query->fetchAll()))
	{
		$tpl->load_template('elements/servers_all.tpl');
		$tpl->compile('content');
	}

	$tpl->show($tpl->result['content']);
?>